<?php
$config = [
    'page_title' => 'HONOR Gallery',
    'event_tagline' => '',
    'sharing_brand' => 'HONOR',
    'file_prefix' => 'honor-elmina-2025',
    'placeholder_copy' => 'Loading your HONOR memories...',
    'palette' => [
        'background' => '#000000',
        'surface' => 'rgba(10, 12, 20, 0.92)',
        'surface_strong' => 'rgba(12, 14, 24, 0.98)',
        'frame_outline' => '#2DA6FF',
        'frame_background' => 'rgba(255, 255, 255, 0.06)',
        'media_fill' => '#0F1118',
        'video_fill' => '#0A0C12',
        'button_shadow' => 'rgba(0, 0, 0, 0.35)',
        'button_disabled' => '#444444',
        'focus_ring' => 'rgba(45, 166, 255, 0.55)',
        'lightbox_overlay' => 'rgba(0, 0, 0, 0.78)',
        'lightbox_surface' => '#0E1018',
        'lightbox_shadow' => 'rgba(0, 0, 0, 0.65)',
        'lightbox_media' => '#000000',
        'action' => '#FFFFFF',
        'action_hover' => '#E6E6E6',
        'action_text' => '#ffffffff',
        'text' => '#FFFFFF',
    ],
];

date_default_timezone_set('Asia/Kuala_Lumpur');

$events = [
    [
        'label' => '6-7 DECEMBER 2025 | ELMINA LAKESIDE MALL',
        'start' => '2025-12-06',
        'end' => '2025-12-07',
    ],
    [
        'label' => '13-14 DECEMBER 2025 | ELMINA LAKESIDE MALL',
        'start' => '2025-12-13',
        'end' => '2025-12-14',
    ],
    [
        'label' => '20-21 DECEMBER 2025 | ELMINA LAKESIDE MALL',
        'start' => '2025-12-20',
        'end' => '2025-12-21',
    ],
    [
        'label' => '24-25 DECEMBER 2025 | ELMINA LAKESIDE MALL',
        'start' => '2025-12-24',
        'end' => '2025-12-25',
    ],
];

$today = new DateTime('today');
$selectedEvent = null;
$upcomingEvent = null;

foreach ($events as $event) {
    $start = new DateTime($event['start']);
    $end = (new DateTime($event['end']))->setTime(23, 59, 59);

    if ($today >= $start && $today <= $end) {
        $selectedEvent = $event;
        break;
    }

    if ($today < $start && $upcomingEvent === null) {
        $upcomingEvent = $event;
    }
}

if ($selectedEvent === null) {
    $selectedEvent = $upcomingEvent ?: end($events);
}

$config['event_tagline'] = $selectedEvent['label'];

$config['share_text'] = [
    'photo' => "Here's your photo from {$config['sharing_brand']}!",
    'video' => "Here's your video from {$config['sharing_brand']}!"
];

$pic = [];
$url = [];
$url2 = [];
$gotPho = "false";
$gotVid = "false";

if (isset($_GET['photo']) && $_GET['photo'] !== '') {
    $picValues = array_values(array_filter(array_map('trim', explode(',', $_GET['photo'])), function ($value) {
        return $value !== '';
    }));

    if (!empty($picValues)) {
        $extPhoto = '.jpg';
        $extVideo = '.mp4';
        $startPhoto = 'Photo/';
        $startVid = 'Video/';

        foreach ($picValues as $value) {
            $photoPath = $startPhoto . $value . $extPhoto;
            $videoPath = $startVid . $value . $extVideo;

            $photoUrl = null;
            if (file_exists($photoPath)) {
                $gotPho = "true";
                $photoUrl = $photoPath . '?m=' . filemtime($photoPath);
            }
            $url[] = $photoUrl;

            $videoUrl = null;
            if (file_exists($videoPath)) {
                $gotVid = "true";
                $videoUrl = $videoPath . '?m=' . filemtime($videoPath);
            }
            $url2[] = $videoUrl;
        }

        $pic = $picValues;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($config['page_title'], ENT_QUOTES, 'UTF-8'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        :root {
            --color-background: <?php echo $config['palette']['background']; ?>;
            --color-surface: <?php echo $config['palette']['surface']; ?>;
            --color-surface-strong: <?php echo $config['palette']['surface_strong']; ?>;
            --color-frame: <?php echo $config['palette']['frame_outline']; ?>;
            --color-action: <?php echo $config['palette']['action']; ?>;
            --color-action-hover: <?php echo $config['palette']['action_hover']; ?>;
            --color-action-text: <?php echo $config['palette']['action_text']; ?>;
            --color-text: <?php echo $config['palette']['text']; ?>;
            --color-frame-bg: <?php echo $config['palette']['frame_background']; ?>;
            --color-media-fill: <?php echo $config['palette']['media_fill']; ?>;
            --color-video-fill: <?php echo $config['palette']['video_fill']; ?>;
            --color-button-shadow: <?php echo $config['palette']['button_shadow']; ?>;
            --color-button-disabled: <?php echo $config['palette']['button_disabled']; ?>;
            --color-focus-ring: <?php echo $config['palette']['focus_ring']; ?>;
            --color-lightbox-overlay: <?php echo $config['palette']['lightbox_overlay']; ?>;
            --color-lightbox-surface: <?php echo $config['palette']['lightbox_surface']; ?>;
            --color-lightbox-shadow: <?php echo $config['palette']['lightbox_shadow']; ?>;
            --color-lightbox-media: <?php echo $config['palette']['lightbox_media']; ?>;
            --max-width: 1040px;
            --transition: 200ms ease;
        }

        * {
            box-sizing: border-box;
        }

        html, body {
            height: 100%;
        }

        body {
            margin: 0;
            font-family: 'arial', sans-serif;
            background: var(--color-background);
            color: var(--color-text);
        }

        @font-face {
            font-family: 'arial';
            src: url('arial.ttf');
        }

        @font-face {
            font-family: 'arialB';
            src: url('arialbd.ttf');
        }

        .page-shell {
            min-height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 32px 16px 48px;
            gap: 32px;
        }

        .page-header {
            width: 100%;
            max-width: var(--max-width);
            text-align: center;
        }

        .page-header__logo img {
            width: min(400px, 70%);
            height: auto;
            display: inline-block;
        }

        .page-header__event {
            margin: 20px 0 0;
            font-family: 'arialB', sans-serif;
            letter-spacing: 0.12em;
            font-size: clamp(12px, 1.2vw, 16px);
            text-transform: uppercase;
        }

        .media-gallery {
            width: 100%;
            max-width: var(--max-width);
        }

        .media-gallery__content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
            gap: 24px;
        }

        .media-gallery__placeholder {
            margin: 0;
            padding: 32px;
            background: var(--color-surface);
            border-radius: 20px;
            text-align: center;
            font-size: clamp(14px, 2.4vw, 18px);
            opacity: 0.85;
        }

        .media-card {
            background: var(--color-surface);
            border-radius: 20px;
            padding: 24px;
            display: flex;
            flex-direction: column;
            gap: 16px;
            min-height: 100%;
        }

        .media-card__visuals {
            display: flex;
            flex-direction: column;
            gap: 16px;
        }

        .media-card__frame {
            background: var(--color-frame-bg);
            border-radius: 12px;
            padding: 10px;
            border: 6px solid var(--color-frame);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.25);
        }

        .media-card__frame img,
        .media-card__frame video {
            width: 100%;
            display: block;
            border-radius: 8px;
            background: var(--color-media-fill);
        }

        .media-card__frame[data-media-kind] {
            cursor: zoom-in;
            outline: none;
            position: relative;
        }

        .media-card__frame[data-media-kind]:focus-visible {
            box-shadow: 0 0 0 3px var(--color-focus-ring);
        }

        .media-card__frame--video video {
            background: var(--color-video-fill);
        }

        .media-card__frame video {
            background: var(--color-video-fill);
        }

        .media-card__actions {
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
        }

        .media-card--video.is-playing .media-card__play-indicator {
            opacity: 0;
        }

        .media-card__button {
            flex: 1 1 150px;
            border: none;
            background: var(--color-action);
            color: var(--color-action-text);
            font-family: 'arialB', sans-serif;
            font-size: 14px;
            padding: 12px 18px;
            border-radius: 999px;
            cursor: pointer;
            transition: background var(--transition), transform var(--transition), box-shadow var(--transition);
        }

        .media-card__button--text-black {
            color: #000;
        }

        .media-card__button:hover,
        .media-card__button:focus-visible {
            background: var(--color-action-hover);
            transform: translateY(-1px);
            box-shadow: 0 10px 20px var(--color-button-shadow);
        }

        .media-card__button:active {
            transform: translateY(0);
        }

        .media-card__button:disabled {
            background: var(--color-button-disabled);
            cursor: default;
            box-shadow: none;
        }

        .brand {
            width: 100%;
            max-width: var(--max-width);
            margin-top: auto;
            padding: 24px 16px 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
            text-align: center;
            font-size: clamp(12px, 1.8vw, 16px);
            opacity: 0.88;
        }

        .brand-line {
            display: flex;
            gap: 6px;
            flex-wrap: wrap;
            justify-content: center;
            align-items: center;
            line-height: 1.5;
        }

        .brand-link {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            font-family: 'arialB', sans-serif;
            color: var(--color-action-text);
            text-decoration: none;
            transition: color var(--transition);
        }

        .brand-link:hover,
        .brand-link:focus-visible {
            color: var(--color-text);
        }

        .brand-link svg {
            width: 1.1em;
            height: 1.1em;
            fill: none;
        }

        .media-lightbox {
            position: fixed;
            inset: 0;
            display: none;
            align-items: center;
            justify-content: center;
            padding: 24px;
            z-index: 1000;
        }

        .media-lightbox.is-open {
            display: flex;
        }

        .media-lightbox__backdrop {
            position: absolute;
            inset: 0;
            background: var(--color-lightbox-overlay);
        }

        .media-lightbox__content {
            position: relative;
            max-width: min(90vw, 960px);
            width: 100%;
            max-height: 90vh;
            background: var(--color-lightbox-surface);
            border-radius: 20px;
            padding: 24px;
            box-shadow: 0 30px 60px var(--color-lightbox-shadow);
            display: flex;
            flex-direction: column;
            gap: 16px;
            z-index: 1;
        }

        .media-lightbox__body {
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: auto;
        }

        .media-lightbox__body img,
        .media-lightbox__body video {
            max-width: 100%;
            max-height: 70vh;
            border-radius: 16px;
            background: var(--color-lightbox-media);
        }

        .media-lightbox__close {
            align-self: flex-end;
            border: none;
            background: var(--color-action);
            color: var(--color-action-text);
            font-family: 'arialB', sans-serif;
            font-size: 14px;
            padding: 8px 16px;
            border-radius: 999px;
            cursor: pointer;
            transition: background var(--transition), transform var(--transition);
        }

        .media-lightbox__close:hover,
        .media-lightbox__close:focus-visible {
            background: var(--color-action-hover);
            transform: translateY(-1px);
        }

        @media (max-width: 768px) {
            .media-card {
                padding: 20px;
            }
            .media-lightbox__content {
                padding: 16px;
            }
        }

        body.lightbox-open {
            overflow: hidden;
        }
    </style>
</head>
<body>
<div class="page-shell">
    <header class="page-header">
        <div class="page-header__logo">
            <img src="logo.png" alt="<?php echo htmlspecialchars($config['sharing_brand'], ENT_QUOTES, 'UTF-8'); ?> logo">
        </div>
        <p class="page-header__event"><?php echo htmlspecialchars($config['event_tagline'], ENT_QUOTES, 'UTF-8'); ?></p>
    </header>

    <section class="media-gallery" aria-label="photo and video downloads">
        <div class="media-gallery__content" id="mediaGallery">
            <p class="media-gallery__placeholder"><?php echo htmlspecialchars($config['placeholder_copy'], ENT_QUOTES, 'UTF-8'); ?></p>
        </div>
    </section>

    <div class="media-lightbox" id="mediaLightbox" aria-hidden="true">
        <div class="media-lightbox__backdrop" id="mediaLightboxBackdrop"></div>
        <div class="media-lightbox__content" role="dialog" aria-modal="true" aria-label="Expanded media view">
            <button type="button" class="media-lightbox__close" id="mediaLightboxClose">Close</button>
            <div class="media-lightbox__body" id="mediaLightboxBody"></div>
        </div>
    </div>

    <footer class="brand">
        <div class="brand-line">Powered by IN:FRAME&trade;</div>
        <div class="brand-line">
            An
            <a class="brand-link" href="https://www.instamedia.my" target="_blank" rel="noopener" aria-label="Visit Instamedia homepage">
                <svg viewBox="0 0 24 24" aria-hidden="true" focusable="false">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                    <polyline points="9,22 9,12 15,12 15,22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></polyline>
                </svg>
                Instamedia&trade;
            </a>
            Experience
        </div>
        <div class="brand-line">
            Follow us
            <a class="brand-link" href="https://www.instagram.com/instamediamy/" target="_blank" rel="noopener" aria-label="Follow Instamedia on Instagram">
                <svg viewBox="0 0 24 24" aria-hidden="true" focusable="false">
                    <rect x="2" y="2" width="20" height="20" rx="5" ry="5" stroke="currentColor" stroke-width="2"></rect>
                    <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z" stroke="currentColor" stroke-width="2"></path>
                    <circle cx="17.5" cy="6.5" r="1" fill="currentColor"></circle>
                </svg>
                @instamediamy
            </a>
        </div>
        <div class="brand-line">&copy; <?php echo date('Y'); ?> Instamedia. All rights reserved.</div>
    </footer>
</div>

<script>
    function iOS() {
        return [
            'iPad Simulator',
            'iPhone Simulator',
            'iPod Simulator',
            'iPad',
            'iPhone',
            'iPod'
        ].includes(navigator.platform) || (navigator.userAgent.includes('Mac') && 'ontouchend' in document);
    }

    function isMobileDevice() {
        const ua = navigator.userAgent || navigator.vendor || window.opera || '';
        const android = /android/i.test(ua);
        const otherMobile = /mobile/i.test(ua);
        return android || iOS() || otherMobile;
    }

    function shouldUseNativeShare() {
        return supportsNativeShare() && isMobileDevice();
    }

    const picArray = <?php echo json_encode($pic, JSON_UNESCAPED_SLASHES); ?>;
    const photoUrls = <?php echo json_encode($url, JSON_UNESCAPED_SLASHES); ?>;
    const videoUrls = <?php echo json_encode($url2, JSON_UNESCAPED_SLASHES); ?>;
    const downloadFilePrefix = <?php echo json_encode($config['file_prefix']); ?>;
    const shareCopy = {
        photo: <?php echo json_encode($config['share_text']['photo']); ?>,
        video: <?php echo json_encode($config['share_text']['video']); ?>
    };

    const hasPhotos = <?php echo $gotPho === "true" ? 'true' : 'false'; ?>;
    const hasVideos = <?php echo $gotVid === "true" ? 'true' : 'false'; ?>;

    const gallery = document.getElementById('mediaGallery');
    gallery.innerHTML = '';

    const lightbox = document.getElementById('mediaLightbox');
    const lightboxBody = document.getElementById('mediaLightboxBody');
    const lightboxClose = document.getElementById('mediaLightboxClose');
    const lightboxBackdrop = document.getElementById('mediaLightboxBackdrop');
    let lastFocusedElement = null;

    if (gallery) {
        gallery.addEventListener('click', handleMediaFrameClick);
        gallery.addEventListener('keydown', handleMediaFrameKeydown);
    }

    if (lightboxClose) {
        lightboxClose.addEventListener('click', closeLightbox);
    }

    if (lightboxBackdrop) {
        lightboxBackdrop.addEventListener('click', closeLightbox);
    }

    document.addEventListener('keydown', handleDocumentKeydown);

    let cardsAdded = 0;

    for (let i = 0; i < picArray.length; i++) {
        const photoUrl = photoUrls[i] || null;
        const videoUrl = videoUrls[i] || null;

        if (!photoUrl && !videoUrl) {
            continue;
        }

        if (photoUrl) {
            const photoPieces = [];
            photoPieces.push('<article class="media-card media-card--photo">');
            photoPieces.push('<div class="media-card__visuals">');
            photoPieces.push('<div class="media-card__frame media-card__frame--photo" role="button" tabindex="0" aria-label="Open photo ' + (i + 1) + ' in full view" data-media-kind="photo" data-media-index="' + i + '">');
            photoPieces.push('<img class="media-card__media" src="' + photoUrl + '" alt="Guest photo ' + (i + 1) + '">');
            photoPieces.push('</div>');
            photoPieces.push('</div>');
            photoPieces.push('<div class="media-card__actions">');
            photoPieces.push('<button type="button" class="media-card__button media-card__button--text-black" onclick="photoClick(' + i + ')">Download</button>');
            photoPieces.push('</div>');
            photoPieces.push('</article>');
            gallery.insertAdjacentHTML('beforeend', photoPieces.join(''));
            cardsAdded++;
        }

        if (videoUrl) {
            const videoPieces = [];
            videoPieces.push('<article class="media-card media-card--video">');
            videoPieces.push('<div class="media-card__visuals">');
            videoPieces.push('<div class="media-card__frame media-card__frame--video">');
            videoPieces.push('<video class="media-card__media" controls preload="metadata" playsinline>');
            videoPieces.push('<source src="' + videoUrl + '" type="video/mp4">');
            videoPieces.push('Your browser does not support the video tag.');
            videoPieces.push('</video>');
            videoPieces.push('</div>');
            videoPieces.push('</div>');
            videoPieces.push('<div class="media-card__actions">');
            videoPieces.push('<button type="button" class="media-card__button media-card__button--text-black" onclick="videoClick(' + i + ')">Download</button>');
            videoPieces.push('</div>');
            videoPieces.push('</article>');
            gallery.insertAdjacentHTML('beforeend', videoPieces.join(''));
            cardsAdded++;
        }
    }

    if (cardsAdded === 0) {
        gallery.innerHTML = '<p class="media-gallery__placeholder">No matching media found. Please verify your download link or try again later.</p>';
    } else {
        if (!hasPhotos) {
            document.body.classList.add('no-photos');
        }
        if (!hasVideos) {
            document.body.classList.add('no-videos');
        }
    }

    function handleMediaFrameClick(event) {
        const frame = getFrameFromEvent(event);
        if (!frame) {
            return;
        }
        event.preventDefault();
        openLightboxFromFrame(frame);
    }

    function handleMediaFrameKeydown(event) {
        if (event.key !== 'Enter' && event.key !== ' ' && event.key !== 'Spacebar') {
            return;
        }
        const frame = getFrameFromEvent(event);
        if (!frame) {
            return;
        }
        event.preventDefault();
        openLightboxFromFrame(frame);
    }

    function getFrameFromEvent(event) {
        if (event.target.closest('.media-card__actions')) {
            return null;
        }
        return event.target.closest('.media-card__frame[data-media-kind]');
    }

    function openLightboxFromFrame(frame) {
        if (!frame) {
            return;
        }
        const kind = frame.getAttribute('data-media-kind');
        const index = parseInt(frame.getAttribute('data-media-index'), 10);
        if (!kind || Number.isNaN(index)) {
            return;
        }
        openLightbox(kind, index);
    }

    function openLightbox(kind, index) {
        const sourceUrl = kind === 'photo' ? photoUrls[index] : videoUrls[index];
        if (!sourceUrl || !lightbox || !lightboxBody) {
            return;
        }

        lastFocusedElement = document.activeElement;

        lightboxBody.innerHTML = '';

        if (kind === 'photo') {
            const img = document.createElement('img');
            img.src = sourceUrl;
            img.alt = 'Guest photo ' + (index + 1);
            lightboxBody.appendChild(img);
        } else {
            const video = document.createElement('video');
            video.controls = true;
            video.autoplay = true;
            video.preload = 'auto';
            video.playsInline = true;
            video.setAttribute('aria-label', 'Guest video ' + (index + 1));
            const source = document.createElement('source');
            source.src = sourceUrl;
            source.type = 'video/mp4';
            video.appendChild(source);
            video.appendChild(document.createTextNode('Your browser does not support the video tag.'));
            lightboxBody.appendChild(video);
        }

        lightbox.classList.add('is-open');
        lightbox.setAttribute('aria-hidden', 'false');
        document.body.classList.add('lightbox-open');

        if (lightboxClose) {
            lightboxClose.focus();
        }
    }

    function closeLightbox() {
        if (!lightbox || !lightbox.classList.contains('is-open')) {
            return;
        }

        lightbox.classList.remove('is-open');
        lightbox.setAttribute('aria-hidden', 'true');
        document.body.classList.remove('lightbox-open');

        if (lightboxBody) {
            lightboxBody.innerHTML = '';
        }

        if (lastFocusedElement && typeof lastFocusedElement.focus === 'function') {
            lastFocusedElement.focus();
        }
        lastFocusedElement = null;
    }

    function handleDocumentKeydown(event) {
        if (event.key === 'Escape') {
            closeLightbox();
        }
    }

    function buildFileName(index, extension) {
        const candidate = picArray[index];
        const usableSlug = typeof candidate === 'string' && candidate.trim() !== '' ? candidate.trim() : '';
        const base = usableSlug || downloadFilePrefix || 'instamedia-capture';
        return base + extension;
    }

    function supportsNativeShare() {
        return typeof navigator === 'object' && typeof navigator.share === 'function';
    }

    function canShareFiles(files) {
        if (!supportsNativeShare()) {
            return false;
        }

        if (typeof navigator.canShare === 'function') {
            try {
                return navigator.canShare({ files: files });
            } catch (error) {
                return false;
            }
        }

        return iOS();
    }

    async function handleDownload(url, fallbackName, shareType) {
        if (!url) {
            return;
        }

        const isVideoShare = shareType === 'video/mp4';
        const shareText = (isVideoShare ? shareCopy.video : shareCopy.photo) || 'Your capture is ready!';

        const canUseFileConstructor = typeof File === 'function';
        const useIOSNativeShare = iOS() && supportsNativeShare() && canUseFileConstructor;

        if (useIOSNativeShare) {
            try {
                const response = await fetch(url, { cache: 'no-store' });
                if (!response.ok) {
                    throw new Error('Failed to fetch media for sharing.');
                }

                const blob = await response.blob();
                const file = new File([blob], fallbackName, { type: shareType });

                await navigator.share({
                    text: shareText,
                    files: [file],
                    title: shareText
                });
                return;
            } catch (error) {
                console.warn('iOS native share failed, falling back when appropriate.', error);
                if (!error || (error.name !== 'AbortError' && error.name !== 'NotAllowedError')) {
                    triggerAnchorDownload(url, fallbackName);
                }
                return;
            }
        }

        const useNativeShare = canUseFileConstructor && shouldUseNativeShare();

        if (useNativeShare) {
            try {
                const response = await fetch(url, { cache: 'no-store' });
                if (!response.ok) {
                    throw new Error('Failed to fetch media for sharing.');
                }

                const blob = await response.blob();
                const file = new File([blob], fallbackName, { type: shareType });

                if (!canShareFiles([file])) {
                    throw new Error('Native share cannot handle provided files.');
                }

                await navigator.share({
                    text: shareText,
                    files: [file],
                    title: shareText
                });
                return;
            } catch (error) {
                console.warn('Native share failed, falling back to download when appropriate.', error);
                if (!error || (error.name !== 'AbortError' && error.name !== 'NotAllowedError')) {
                    triggerAnchorDownload(url, fallbackName);
                }
                return;
            }
        }

        triggerAnchorDownload(url, fallbackName);
    }

    function triggerAnchorDownload(url, filename) {
        const anchor = document.createElement('a');
        anchor.href = url;
        anchor.download = filename || '';
        anchor.rel = 'noopener';
        document.body.appendChild(anchor);
        anchor.click();
        document.body.removeChild(anchor);
    }

    function photoClick(target) {
        const url = photoUrls[target];
        if (!url) {
            return;
        }
        handleDownload(url, buildFileName(target, '.jpg'), 'image/jpeg');
    }

    function videoClick(target) {
        const url = videoUrls[target];
        if (!url) {
            return;
        }
        handleDownload(url, buildFileName(target, '.mp4'), 'video/mp4');
    }
</script>
</body>
</html>
